/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import java.net.MalformedURLException;
import java.net.URL;
import net.montoyo.wd.client.gui.controls.Button;
import net.montoyo.wd.client.gui.controls.TextField;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.VideoType;

public class YTButton
extends Button
implements TextField.TextChangeListener {
    private TextField urlField;

    public YTButton() {
        this.btn.field_146126_j = "YT";
        this.btn.field_146124_l = false;
        this.shiftColor = -39836;
    }

    @Override
    protected boolean onClick() {
        if (this.urlField != null) {
            URL url;
            String urlStr = Util.addProtocol(this.urlField.getText());
            try {
                url = new URL(urlStr);
            }
            catch (MalformedURLException ex) {
                return true;
            }
            VideoType vt = VideoType.getTypeFromURL(url);
            if (vt == VideoType.YOUTUBE) {
                this.urlField.setText(VideoType.YOUTUBE_EMBED.getURLFromID(vt.getVideoIDFromURL(url), this.shiftDown));
            }
        }
        return true;
    }

    public void setURLField(TextField tf) {
        if (this.urlField != null) {
            tf.removeTextChangeListener(this);
        }
        this.urlField = tf;
        if (this.urlField != null) {
            tf.addTextChangeListener(this);
        }
    }

    public TextField getURLField() {
        return this.urlField;
    }

    @Override
    public void load(JsonOWrapper json) {
        Object ctrl;
        super.load(json);
        String tfName = json.getString("urlField", null);
        if (tfName != null && (ctrl = this.parent.getControlByName(tfName)) != null && ctrl instanceof TextField) {
            this.urlField = (TextField)ctrl;
            this.urlField.addTextChangeListener(this);
        }
    }

    @Override
    public void onTextChange(TextField tf, String oldContent, String newContent) {
        this.btn.field_146124_l = VideoType.getTypeFromURL(Util.addProtocol(newContent)) == VideoType.YOUTUBE;
    }
}

